﻿using System;
using System.IO;
using System.Net;
using System.Net.Cache;
namespace HttpRequestResponse
{
    class Program
    {
        static void Main(string[] args)
        {
            {
                // Listing 13-13. Pobieranie łańcucha znakowego za pomocą klas HttpWebRequest oraz HttpWebResponse
                HttpWebRequest req = (HttpWebRequest) WebRequest.Create("http://helion.pl/");
                using (HttpWebResponse resp = (HttpWebResponse) req.GetResponse())
                using (Stream respStream = resp.GetResponseStream())
                using (StreamReader reader = new StreamReader(respStream))
                {
                    string pageContent = reader.ReadToEnd();
                    Console.WriteLine(pageContent);
                }
            }

            {
                // Listing 13-14. Modyfikacja nagłówka określającego agenta użytkownika za pomocą klasy HttpWebRequest
                HttpWebRequest req = (HttpWebRequest) WebRequest.Create("http://helion.pl/");
                req.UserAgent = "Mozilla/5.0 (iPod; U; CPU iPhone OS 2_2_1 like Mac OS X; en-us) AppleWebKit/525.18.1 (KHTML, like Gecko) Mobile/5H11a";
                using (HttpWebResponse resp = (HttpWebResponse) req.GetResponse())
                using (Stream respStream = resp.GetResponseStream())
                using (StreamReader reader = new StreamReader(respStream))
                {
                    string pageContent = reader.ReadToEnd();
                    Console.WriteLine(pageContent);
                }
            }

            {
                // Listing 13-15. Asynchroniczne uzyskiwanie odpowiedzi
                HttpWebRequest req = (HttpWebRequest) WebRequest.Create("http://helion.pl/");
                req.BeginGetResponse(delegate(IAsyncResult asyncResult)
                {
                    using (HttpWebResponse resp = (HttpWebResponse)
                    req.EndGetResponse(asyncResult))
                    using (Stream respStream = resp.GetResponseStream())
                    using (StreamReader reader = new StreamReader(respStream))
                    {
                        string pageContent = reader.ReadToEnd();
                        Console.WriteLine(pageContent);
                    }
                }, null);

                Console.ReadKey();
            }
        }

        static void Credentials()
        {
            {
                // Listing 13-16. Umożliwianie korzystania ze zintegrowanego uwierzytelniania
                HttpWebRequest request =
                    (HttpWebRequest) WebRequest.Create("http://intraweb/");
                request.Credentials = CredentialCache.DefaultCredentials;
            }

            {
                // Listing 13-17. Przekazywanie danych uwierzytelniających dla podstawowej lub skrótowej autoryzacji
                HttpWebRequest request =
                    (HttpWebRequest) WebRequest.Create("https://intraweb/");
                request.Credentials = new NetworkCredential("uzytkownik1", "h@sl0");
            }
        }

        static void Proxy()
        {
            // Listing 13-19. Wskazywanie określonego proxy
            HttpWebRequest request =
            (HttpWebRequest) WebRequest.Create("https://intraweb/");
            request.Proxy = new WebProxy("http://corpwebproxy/");
        }

        static void Cache()
        {
            // Listing 13-20. Określanie polityki korzystania z pamięci podręcznej
            HttpRequestCachePolicy cachePolicy = new HttpRequestCachePolicy(
            HttpRequestCacheLevel.CacheIfAvailable);
            HttpWebRequest request =
            (HttpWebRequest) WebRequest.Create("https://intraweb/");
            request.CachePolicy = cachePolicy;
        }

        static void Cookies()
        {
            // Listing 13-21. Pobieranie ciasteczek z odpowiedzi serwera    
            CookieContainer container = new CookieContainer();

            Uri address = new Uri("http://helion.pl/");
            HttpWebRequest req = (HttpWebRequest) WebRequest.Create(address);
            HttpWebResponse resp = (HttpWebResponse) req.GetResponse();

            CookieCollection cookies = resp.Cookies;
            container.Add(address, cookies);
        }
    }
}
